schedule function p:tick20t 20t

function p:weather

execute as @a[tag=alive] run function p:location_activates_ztp

#zombie tp if red wool in front and or void trash
execute as @e[type=zombie] at @s if block ^ ^ ^1 minecraft:red_wool run execute at @r[tag=alive,gamemode=adventure] run tp @s @e[type=area_effect_cloud,tag=active,tag=!deactive,sort=nearest,limit=1]
execute as @e[type=zombie,scores={VoidTimer=20..}] at @s run tp @s ^ ^ ^2

#healing zombie potion throw timer
execute if score #healingz bool matches 1 run execute as @e[type=zombie,tag=healing] run function p:healingz_timer

#end zombie teleport timer
execute if score #endz bool matches 1 run execute as @e[type=zombie,tag=end] run function p:endz_timer

# check for absorption
effect clear @a[tag=alive,nbt={AbsorptionAmount:0.0f}] minecraft:absorption

# zombie joins zombie team
team join Zombie @e[type=zombie,tag=!eeboss]

#remove friend after some time
scoreboard players add @e[type=!zombie,team=friend] timer 20
kill @e[type=!zombie,type=!snow_golem,type=!item_frame,type=!glow_item_frame,type=!area_effect_cloud,team=friend,scores={timer=6000..}]

# deepslate iron golem count
scoreboard players set #IronGolemCounterDeepslate counter 0
execute as @e[type=minecraft:iron_golem] at @s if biome ~ ~ ~ minecraft:warped_forest run scoreboard players add #IronGolemCounterDeepslate counter 1

# sewer iron golem count
scoreboard players set #IronGolemCounterSewer counter 0
execute as @e[type=minecraft:iron_golem] at @s if biome ~ ~ ~ minecraft:swamp run scoreboard players add #IronGolemCounterSewer counter 1

# crimson binky count
scoreboard players set #BinkyCounterCrimson counter 0
execute as @e[type=minecraft:wolf,tag=binky] at @s if biome ~ ~ ~ minecraft:crimson_forest run scoreboard players add #BinkyCounterCrimson counter 1

#player and zombie gravity change if in crimson forest or warped forest
execute as @a[tag=played] at @s if biome ~ ~ ~ crimson_forest run function p:gravity_lower_crimson
execute as @a[tag=played] at @s if biome ~ ~ ~ warped_forest run function p:gravity_lower_warped
execute as @a[tag=played] at @s unless biome ~ ~ ~ crimson_forest unless biome ~ ~ ~ warped_forest run attribute @s gravity base reset
execute as @e[type=zombie] at @s unless biome ~ ~ ~ crimson_forest unless biome ~ ~ ~ warped_forest run attribute @s gravity base reset

# players in lobby get saturation
execute as @a[team=Lobby,tag=!tutorial] run effect give @s minecraft:saturation 40 127 true

# If game not in progress, remove tags and scoreboards from players that rejoin
execute as @a[scores={offline=1..}] if score #game_in_progress bool matches 0 run function p:offline
execute as @a[scores={offline=1..},team=Lobby] if score #game_in_progress bool matches 1 run function p:offline

# items that need to glow
execute at @a[tag=alive] as @e[type=item,nbt={Item:{id:"minecraft:iron_ingot"}},distance=..20] run data merge entity @s {Glowing:1b}
execute at @a[tag=alive] as @e[type=item,nbt={Item:{id:"minecraft:gold_ingot"}},distance=..20] run data merge entity @s {Glowing:1b}
execute at @a[tag=alive] as @e[type=item,nbt={Item:{id:"minecraft:gold_nugget"}},distance=..20] run data merge entity @s {Glowing:1b}
execute at @a[tag=alive] as @e[type=item,nbt={Item:{id:"minecraft:glistering_melon_slice"}},distance=..20] run data merge entity @s {Glowing:1b}

# library zombie gives darkness
execute if score #libraryz bool matches 1 as @e[type=zombie,tag=library] at @s if entity @a[tag=alive,distance=..6] run function p:libraryz_darkness

# king zombie healing
execute if score #kingz bool matches 1 run execute as @e[type=zombie,tag=king] run function p:kingz_timer

#mage zombie spawn skeleton timer
execute if score #magez bool matches 1 run execute as @e[type=zombie,tag=mage] run function p:magez_timer

#stick of ember
scoreboard players add @a[tag=alive,nbt={Inventory:[{id:"minecraft:blaze_rod"}]}] firestick 20

#increase player size based off attributes
attribute @a[team=!Respawn,tag=!size,tag=Berserk,limit=1] scale base set 1.05
attribute @a[team=!Respawn,tag=!size,tag=!Conjur,tag=!Berserk,tag=!Leech,limit=1] scale base set 1
attribute @a[team=!Respawn,tag=!size,tag=Conjur,limit=1] scale base set 0.95
attribute @a[team=!Respawn,tag=!size,tag=Leech,limit=1] scale base set 0.9

#ztp if too far
execute as @e[type=zombie,tag=!special] at @s unless entity @s[x=-72,y=296,z=185,distance=..3] unless entity @a[tag=alive,distance=..59] if entity @a[tag=alive,distance=60..] at @r[tag=alive,gamemode=adventure] run tp @s @e[type=area_effect_cloud,tag=active,tag=!deactive,sort=random,distance=..50,limit=1]

#ztp if zombie under player for too long
execute as @e[type=zombie,tag=!special] at @s positioned ~-59 ~-10 ~-59 unless entity @a[tag=alive,dx=118,dy=14,dz=118] run scoreboard players add @s stillTime 10

#kill zombies that fall into pit under bridge
kill @e[type=zombie,tag=!boss,x=-44,y=20,z=49,dx=14,dy=2,dz=19]
kill @e[type=experience_orb,x=-198,y=-4,z=20,dz=19,dx=5]

#villager screams after falling into pit
execute store success score #kill_villager bool run kill @e[type=villager,x=-198,y=-4,z=20,dz=19,dx=5]
execute if score #kill_villager bool matches 1 run playsound minecraft:entity.player.hurt_drown master @a[x=-173,y=15,z=18,dz=23,dx=5,dy=3] -198 -4 29 2.5 .1
execute if score #kill_villager bool matches 1 run playsound minecraft:entity.ghast.hurt master @a[x=-173,y=15,z=18,dz=23,dx=5,dy=3] -198 -4 29 2.5 .5

#if no normal zombies remaining, summon some
#execute if score #stage counter matches 1.. unless entity @e[type=zombie,tag=normal] run function p:z_spawn_if_none/z_spawn_init

#auto delete drops
execute as @a[tag=played] run function p:clear_drops

#barrier block removed if door opened for ravine
execute if block -103 39 43 air run setblock -133 41 30 air
execute unless block -103 39 43 air if block -128 40 37 red_wool run setblock -133 41 30 barrier
execute if block -128 40 37 air run setblock -133 41 30 air
execute unless block -128 40 37 air if block -103 39 43 red_wool run setblock -133 41 30 barrier

#remove player size if not alive
execute as @a[tag=!alive,tag=!Berserk,tag=!Aegis,tag=!Conjur,tag=!Leech] run attribute @s scale base reset

#hunter's calling
execute if score #power bool matches 1 as @a[tag=alive,scores={goathorn=1..}] run function p:goathorn

#run armor kit macros as player
execute as @a[tag=alive] run function p:armormacros

#sewer pipe tp
execute if score #power bool matches 1 as @a[tag=alive,gamemode=adventure,x=-63,y=6,z=60,dx=6,dz=13,dy=9] run function p:sewer_pipe_detect
execute if score #power bool matches 1 unless entity @a[tag=alive,gamemode=adventure,x=-60,y=6,z=65,dx=3,dz=2,dy=9] run schedule clear p:sewer_pipe_detect

#store zombie number for zombie limit
execute store result score #znum num if entity @e[type=zombie,tag=normal]

#make items around players invulnerable
execute at @a[tag=alive] as @e[distance=..10,type=item] run data merge entity @s {Invulnerable:1b}